\name{customize}
\alias{customize}
\title{Customization function for panel}
\usage{
customize(p, par)
}
\arguments{
  \item{p}{a ggplot2 plot object}

  \item{par}{parameters object like in
  \code{\link{panel_boxplot}}}
}
\value{
a ggplot2 plot object with added customizations
}
\description{
This function is supposed to make small changes in the
panel function appearance like changing color scheme for
example. It has to match with the output of the
corresponding panel function. Check examples in
plot.gosummaries to see how to write one yourself.
}
\examples{
\dontrun{
data(gs_limma_exp)

cust = function(p, par){
	p = p + scale_fill_brewer(par$classes, type = "qual", palette = 1)
	return(p)
}

plot(gs_limma_exp, classes = "Tissue", panel_plot = panel_boxplot, panel_customize = cust,
 fontsize = 8)
}
}
\author{
Raivo Kolde <rkolde@gmail.com>
}

