% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_deriv_nn.R
\name{compute_deriv_nn}
\alias{compute_deriv_nn}
\title{Calculate derivatives of CERF for nnGP}
\usage{
compute_deriv_nn(
  w,
  w_obs,
  GPS_m,
  y_obs,
  hyperparam,
  n_neighbor,
  expand,
  block_size,
  kernel_fn = function(x) exp(-x),
  kernel_deriv_fn = function(x) -exp(-x)
)
}
\arguments{
\item{w}{A scalar of exposure level of interest.}

\item{w_obs}{A vector of observed exposure levels of all samples.}

\item{GPS_m}{A data.frame of GPS vectors. Including:
\itemize{
\item Column 1: GPS values.
\item Column 2: Prediction of exposure for covariate of each data sample (e_gps_pred).
\item Column 3: Standard deviation of  e_gps (e_gps_std).
}}

\item{y_obs}{A vector of observed outcome values.}

\item{hyperparam}{A vector of hyper-parameters in the GP model.}

\item{n_neighbor}{The number of nearest neighbors on one side (see also \code{expand}).}

\item{expand}{Scaling factor to determine the total number of nearest
neighbors. The total is \code{2 * expand * n_neighbor}.}

\item{block_size}{The number of samples included in a computation block. Mainly used to
balance the speed and memory requirement. Larger \code{block_size} is faster, but requires more memory.}

\item{kernel_fn}{The covariance function. The input is the square of Euclidean distance.}

\item{kernel_deriv_fn}{The partial derivative of the covariance function. The input is the square of Euclidean distance.}
}
\value{
A scalar of estimated derivative of CERF at \code{w} in nnGP.
}
\description{
Calculates the posterior mean of the derivative of CERF at a given
exposure level with nnGP.
}
\keyword{internal}
