% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.GPCMlasso.R
\name{predict.GPCMlasso}
\alias{predict.GPCMlasso}
\title{Predict function for GPCMlasso}
\usage{
\method{predict}{GPCMlasso}(object, coefs = NULL, newdata = NULL,
  type = c("link", "response"), ...)
}
\arguments{
\item{object}{\code{GPCMlasso} object}

\item{coefs}{Optional vector of coefficients, can be filled with a specific 
row from \code{object$coefficients}. If not specified, \code{coefs} are specififed to be
the BIC-optimal coefficients or, if cross-validation was performed, the optimal 
coefficients according to cross-validation.}

\item{newdata}{List possibly containing slots Y, X, Z1 and Z2 to use new data for prediction.}

\item{type}{Type "link" gives vectors of linear predictors for separate categories 
(of length $k_i-1$) and type "response" gives the respective probabilities (of length $k_i$).}

\item{...}{Further predict arguments.}
}
\description{
Predict function for a \code{GPCMlasso} object. 
Predictions can be linear predictors or probabilities separately for each person and each item.
}
\details{
Results are lists of vectors with length equal to the number 
of response categories $k_i$ in case of
probabilities (\code{type="response"}) or 
$k_i-1$ in case of linear predictors (\code{type="link"}).
}
\examples{
data(tenseness_small)

## formula for simple model without covariates
form.0 <- as.formula(paste("cbind(",paste(colnames(tenseness_small)[1:5],collapse=","),")~0"))

######
## fit simple RSM where loglikelihood and score function are evaluated parallel on 2 cores
rsm.0 <- GPCMlasso(form.0, tenseness_small, model = "RSM", 
control= ctrl_GPCMlasso(cores=2))
rsm.0

\dontrun{
## formula for model with covariates (and DIF detection)
form <- as.formula(paste("cbind(",paste(colnames(tenseness_small)[1:5],collapse=","),")~."))

######
## fit GPCM model with 10 different tuning parameters
gpcm <- GPCMlasso(form, tenseness_small, model = "GPCM", 
                  control = ctrl_GPCMlasso(l.lambda = 10))
gpcm
plot(gpcm)
pred.gpcm <- predict(gpcm)
trait.gpcm <- trait.posterior(gpcm)

######
## fit RSM, detect differential step functioning (DSF)
rsm.DSF <- GPCMlasso(form, tenseness_small, model = "RSM", DSF = TRUE, 
                     control = ctrl_GPCMlasso(l.lambda = 10))
rsm.DSF
plot(rsm.DSF)

## create binary data set
tenseness_small_binary <- tenseness_small
tenseness_small_binary[,1:5][tenseness_small[,1:5]>1] <- 2

######
## fit and cross-validate Rasch model
set.seed(1860)
rm.cv <- GPCMlasso(form, tenseness_small_binary, model = "RM", cv = TRUE, 
                   control = ctrl_GPCMlasso(l.lambda = 10))
rm.cv
plot(rm.cv)
}
}
\seealso{
\code{\link{GPCMlasso}}
}
\author{
Gunther Schauberger\cr \email{gunther@stat.uni-muenchen.de}
}
