% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik.R
\name{logLikFunc}
\alias{logLikFunc}
\title{Compute logLikelihood}
\usage{
logLikFunc(par, f, Xf, covtype = "matern5_2", noise.var = 1e-6,
     seed = NULL, return.all = FALSE)
}
\arguments{
\item{par}{vector contains the \code{coef.m} and the log of \code{coef.cov}.}

\item{f}{vector of binary observations (+/-1) corresponding to the class labels.}

\item{Xf}{a matrix representing the design of experiments.}

\item{covtype}{a character string specifying the covariance structure for the latent GP. Default is \code{matern_5_2}.}

\item{noise.var}{nugget effect. Default is 1e-6.}

\item{seed}{to fix the seed, default is \code{NULL}.}

\item{return.all}{an optional boolean. If \code{FALSE}, only the log-likelihood is returned; if \code{TRUE}, \code{K} and \code{cov.fun} are also returned. Default is \code{FALSE}.}
}
\value{
\item{logLik}{the log-likelihood.}
\item{K}{the covariance matrix of latent process.}
\item{cov.fun}{a DiceKriging object specifying the covariance structure.}
}
\description{
Computes and returns the  log-likelihood value, the covariance matrix of latent process and covariance structure of a Gaussian Process Classification (GPC) model.
}
\examples{
# ------------
# A 1D example
# ------------

# Design of Experiments Xf and the corresponding signs f
Xf <- as.matrix(c(0.08, 0.27, 0.42, 0.65, 0.78, 0.84))
f <- c(1, -1, -1, 1, -1, -1)

# loglikelihood and covariance matrix at Xf 
par <- c(coef.cov = 0.1, coef.m = 0)
result <- logLikFunc(par = par, f = f, Xf = Xf, return.all = TRUE)
K <- result$K
logLik <- result$logLik
print(logLik)

}
\references{
Bachoc, F., Helbert, C. & Picheny, V. Gaussian process optimization with failures: classification and convergence proof. \emph{J Glob Optim} \bold{78}, 483–506 (2020). \doi{10.1007/s10898-020-00920-0}

Botev, Z.,  Belzile, L. TruncatedNormal: Truncated Multivariate Normal and Student Distributions. R package version 2.2.2 https://cran.r-project.org/package=TruncatedNormal

Botev, Z. I.  (2017), \emph{The normal law under linear restrictions:simulation and estimation via minimax tilting}, Journal of the Royal Statistical Society, Series B, \bold{79} (1), pp. 1-24.

Roustant, O., Ginsbourger, D. & Deville, Y. Contributors: Chevalier, C. , Richet, Y. DiceKriging: Kriging Methods for Computer Experiments. R package version 1.6.0. \url{https://CRAN.R-project.org/package=DiceKriging}.
}
\author{
Morgane MENZ, Céline HELBERT, Victor PICHENY, François BACHOC. Contributors: Naoual SERRAJI.
}
