% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GP_deviance.R
\name{sig_invb}
\alias{sig_invb}
\title{Internal tools}
\usage{
sig_invb(X, Y, beta, corr = list(type = "exponential", power = 1.95),
  nug_thres = 20)
}
\arguments{
\item{X}{the (\emph{n} x \emph{d}) design matrix}

\item{Y}{the (\emph{n} x 1) vector of simulator outputs}

\item{beta}{a (\emph{d} x 1) vector of correlation hyper-parameters, as
described in \code{\link{corr_matrix}}}

\item{corr}{a list of parameters for the specifing the correlation to be
used. See \code{\link{corr_matrix}}.}

\item{nug_thres}{a parameter used in computing the nugget. See
\code{\link{GP_fit}}.}
}
\value{
list with elements delta, L, mu_hat, Sig_invb
}
\description{
shared utilities between \code{\link{GP_deviance}}
and \code{\link{GP_fit}}
}
\examples{
set.seed(3234)
GPfit:::sig_invb(
    X = matrix((0:10) / 10), 
    Y = runif(11), 
    beta = 1.23)
}
