% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d2pMax.R
\name{d2pMax}
\alias{d2pMax}
\title{Provides the number of polynomial terms \code{pMax}
given \code{dMax} and \code{nVar}}
\usage{
d2pMax(nVar, dMaxKnown)
}
\arguments{
\item{nVar}{Number of variables considered in the polynomial formulation.}

\item{dMaxKnown}{The maximum polynomial degree \code{dMax}}
}
\value{
The number \code{pMax} of polynomial terms used to code
a polynomial equation
}
\description{
Computes the number of polynomial terms \code{pMax}
             used to formulate an equation given
             the maximal polynomial degree \code{dMax}
             and the number of variables \code{nVar}
             following the conventions as defined by fuction \code{poLabs}.
}
\examples{
#############
# Example 1 #
#############
# Maximum polynomial degree ?
# number of variables:
nVar <- 3
# polynomial degree:
dMax <- 3
# The maximal polynomial degree used for coding the polynomial is:
d2pMax(nVar,dMax)

}
\seealso{
\code{\link{gloMoId}}, \code{\link{gPoMo}}, \code{\link{poLabs}}
}
\author{
Sylvain Mangiarotti
}
