% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\name{kernel}
\alias{kernel}
\title{kernel}
\usage{
kernel(x1, theta, x2 = NULL, g = NULL)
}
\arguments{
\item{x1}{matrix of input locations}

\item{theta}{a scalar or vector specifying the lengthscale parameter. If a vector is provided, a separable kernel function is used.
If a scalar is provided and \code{x1} has more than one column, an isotropic kernel is assumed.}

\item{x2}{matrix of second input locations. If \code{NULL}, distance is computed between \code{x1} and itself.}

\item{g}{a jitter term. It is added when \code{x2=NULL} for computational stability.}
}
\value{
a matrix representing the evaluated kernel function
}
\description{
Compute the squared exponential kernel defined as \eqn{k = \exp(-\theta (x - x')^2) + g} , where \eqn{\theta} is the lengthscale parameter and \eqn{g} is a jitter term.
Both isotropic and separable kernels are supported.
}
\details{
Matrix computations are implemented in C++ for improved performance and computational efficiency.
}
\examples{
### isotropic ###
x <- matrix(seq(0, 10, length=10), ncol=1)
theta <- 5
k <- kernel(x1=x, theta=theta)

### anisotropic ###
x <- matrix(seq(0, 20, length=20), ncol=2)
theta <- c(2, 4)
k <- kernel(x1=x, theta=theta)

}
