% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getYlimits.R
\name{getYlimits}
\alias{getYlimits}
\title{Setting limits for the y-axis}
\usage{
getYlimits(Y, V, minRng = 0.5)
}
\arguments{
\item{Y}{Matrix containing observed values; items in rows, time points in columns.}

\item{V}{Matrix containing variances; items in rows, time points in columns.}

\item{minRng}{Minimum range for the y axis in the plot. Default value is set to 0.5.}
}
\value{
Return y-axis limits.
}
\description{
Function for setting decent y-axis limits.
}
\examples{
Y=matrix(c(1,2,3,4,5,6),2,3)
V=0.1*Y
y_lims=getYlimits(Y,V)

}
\author{
Hande Topa, \email{hande.topa@helsinki.fi}
}
\keyword{axis}
\keyword{limits}

