% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getModelKernParams.R
\name{getModelKernParams}
\alias{getModelKernParams}
\title{Getting the values of the kernel parameters of the GP model}
\usage{
getModelKernParams(model, transformed = FALSE)
}
\arguments{
\item{model}{GP model}

\item{transformed}{Logical variable indicating whether the transformed values of the
parameters are desired or not. Default is set to FALSE.}
}
\value{
Return vector of values of the kernel parameters of the GP model.
}
\description{
Function for getting the kernel parameter values of the GP model. In order to get the
transformed values, set transformed to TRUE.
}
\examples{
x=as.matrix(seq(1,10))
y=as.matrix(sin(x))
v=as.matrix(runif(10,0,0.5))
kernelTypes=c("rbf","white","fixedvariance")
model=constructModel(x,y,v,kernelTypes)
params=getModelKernParams(model)

}
\author{
Hande Topa, \email{hande.topa@helsinki.fi}
}
\keyword{parameter}
