% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vecchia_laplace_NR.R
\name{calculate_posterior_VL}
\alias{calculate_posterior_VL}
\title{Vecchia Laplace extension of GPVecchia for non-Gaussian data}
\usage{
calculate_posterior_VL(z, vecchia.approx,
  likelihood_model = c("gaussian", "logistic", "poisson", "gamma",
  "beta", "gamma_alt"), covparms, covmodel = "matern",
  likparms = list(alpha = 2, sigma = sqrt(0.1)), max.iter = 50,
  convg = 1e-06, return_all = FALSE, y_init = NA,
  prior_mean = rep(0, length(z)), verbose = FALSE)
}
\arguments{
\item{z}{an array of real numbers representing observations}

\item{vecchia.approx}{a vecchia object as generated by vecchia_specify()}

\item{likelihood_model}{text describing likelihood model to be used for observations.  Can be "gaussian","logistic", "poisson", "gamma", or "beta"}

\item{covparms}{covariance parameters as a vector}

\item{covmodel}{type of the model covariance or selected elements of the covariance matrix}

\item{likparms}{likelihood parameters for the likelihood_model, as a list.  Default values are sqrt(.1) for Gaussian noise and 2 for the alpha parameter for Gamma data.}

\item{max.iter}{maximum iterations to perform}

\item{convg}{convergence criteria.  End iterations if the Newton step is this small}

\item{return_all}{Return additional posterior covariance terms, TRUE or FALSE}

\item{y_init}{Specify initial guess for posterior mode}

\item{prior_mean}{specify the prior latent mean}

\item{verbose}{if TRUE messages about the posterior estimation will be displayed}
}
\value{
multivariate normal posterior parameters calculated by the Vecchia-Laplace approximation
}
\description{
Vecchia Laplace extension of GPVecchia for non-Gaussian data
}
\examples{
z=rnorm(10); locs=matrix(1:10,ncol=1); vecchia.approx=vecchia_specify(locs,m=5)
calculate_posterior_VL(z,vecchia.approx,"gaussian",covparms=c(1,2,.5))
}
