% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createU.R
\name{createU}
\alias{createU}
\title{create the sparse triangular U matrix for specific parameters}
\usage{
createU(vecchia.approx, covparms, nuggets, covmodel = "matern")
}
\arguments{
\item{vecchia.approx}{object returned by \code{\link{vecchia_specify}}}

\item{covparms}{vector of covariance parameters}

\item{nuggets}{nugget variances -- if a scalar is provided, variance is assumed constant}

\item{covmodel}{covariance model. currently implemented:}
}
\value{
list containing the sparse upper triangular U,
    plus additional objects required for other functions
}
\description{
create the sparse triangular U matrix for specific parameters
}
\examples{
z=rnorm(9); locs=matrix(1:9,ncol=1); vecchia.approx=vecchia_specify(locs,m=5)
U.obj=createU(vecchia.approx,covparms=c(1,2,.5),nuggets=.2)
}
