% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRPgrouptest.R
\name{GRPgrouptest}
\alias{GRPgrouptest}
\title{Test significance of groups or individual predictors in high-dimensional generalized linear models}
\usage{
GRPgrouptest(X, y, fam = c("gaussian", "binomial", "poisson"), G,
  B = 1000L, penalize = ifelse(p - length(G) >= n, TRUE, FALSE))
}
\arguments{
\item{X}{Input matrix with \code{n} rows, each a \code{p}-dimensional observation vector.}

\item{y}{Response vector.}

\item{fam}{Must be "gaussian", "binomial" or "poisson".}

\item{G}{A vector with indices of variables,
whose significance we wish to ascertain, after controlling for variables in
\code{X}. The size of \code{G} can be at most \code{p-2}.}

\item{B}{The number of bootstrap samples to approximate the distribution of
the test statistic. Note that the p-value returned will always be
 at least \code{1/(B+1)}.}

\item{penalize}{If \code{TRUE}, penalization is used when fitting GLM models.}
}
\value{
The output is a single p-value.
}
\description{
The function can test significance of (potentially large) groups of predictors
in low- and high-dimensional generalized linear models.
Outputs a p-value.
}
\details{
The function can test the significance of a set of variables in a generalized linear model,
  whose indices are specified by \code{G}.
  \code{penalize = TRUE} is needed for high-dimensional settings where the number of variables
  not in \code{G} is larger than the number of observations. We then employ a penalized regression
  to regress \code{y} on to these variables implemented in \code{cv.glmnet} from package \code{glmnet}.
  For the low-dimensional case, an unpenalized regression may be used.
}
\examples{
# Testing significance of a group of predictors in logistic regression

set.seed(1)
X <- matrix(rnorm(300*50), 300, 50)
z <- X[, 1:5] \%*\% rep(1, 5)
pr <- 1/(1 + exp(-z))
y <- rbinom(nrow(X), 1, pr)
(out <- GRPgrouptest(X, y, fam = "binomial", G = 5:10, B = 1000))

}
\references{
Janková, J., Shah, R. D., Bühlmann, P. and Samworth, R. (2019)
\emph{Goodness-of-fit testing in high-dimensional generalized linear models}
\url{https://arxiv.org/abs/1908.03606}
}
