% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeSymmetricDist.R
\name{makeSymmetricDist}
\alias{makeSymmetricDist}
\title{makeSymmetricDist}
\usage{
makeSymmetricDist(mat, FUN = mean)
}
\arguments{
\item{mat}{A non-symmetrical matrix of distances.}

\item{FUN}{function applied to the non-symmetrical distance pairs to aggregate into a symmetrical distance.}
}
\value{
A symmetrical distance matrix.
}
\description{
Utility function to convert a matrix of non-symmetrical distances (A->B != B->A) into a symmetrical one.
A method of aggregating the non-symmetrical distances can be specified. The default aggregation method is
\code{mean}.
}
\examples{

# Start with a non-symmetrical distance matrix.
ns_dist.mat <- matrix( nrow = 3, ncol = 3,
                       data = c( NA, -70, -47,
                                 -63, NA, -10,
                                 -53, -17, NA ) )

# Calculate a symmetric distance matrix using 'mean'
mean_dist.mat <- makeSymmetricDist( ns_dist.mat, FUN = mean )

# minimum or max can also be used:
min_dist.mat <- makeSymmetricDist( ns_dist.mat, FUN = min )

}
