% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_dwelltime.R
\name{set_dwelltime}
\alias{set_dwelltime}
\title{Set Dwell Time for GTFS Stops}
\usage{
set_dwelltime(gtfs, duration = 30, trips = "all", stops = "all")
}
\arguments{
\item{gtfs}{A GTFS object, preferably of class `wizardgtfs`. If not, the function will attempt to convert it using `GTFSwizard::as_wizardgtfs()`.}

\item{duration}{A numeric value specifying the desired dwell time in seconds. Defaults to 30 seconds.}

\item{trips}{A character vector of trip IDs for which the dwell time will be updated. Use `'all'` to update all trips (default).}

\item{stops}{A character vector of stop IDs for which the dwell time will be updated. Use `'all'` to update all stops (default).}
}
\value{
A modified GTFS object with updated arrival and departure times in the `stop_times` table.
}
\description{
The `set_dwelltime` function updates the arrival and departure times in the `stop_times` table of a GTFS object based on a specified dwell time duration. The function modifies the dwell time for selected trips and stops, or for all trips and stops by default.
}
\details{
This function calculates the midpoint between the original `arrival_time` and `departure_time` for the specified trips and stops. It then adjusts these times based on the desired dwell time (`duration`), ensuring that the dwell time is evenly distributed around the midpoint.
}
\note{
Ensure the `stop_times` table contains valid `arrival_time` and `departure_time` values. Empty or missing times may cause computation issues.
}
\examples{
# Set dwell time to 30 seconds for specific trips and stops
set_dwelltime(for_rail_gtfs, duration = 30,
               trips = for_rail_gtfs$trips$trip_id[1:2],
               stops = for_rail_gtfs$stops$stop_id[1:2])

}
\seealso{
[GTFSwizard::as_wizardgtfs()], [GTFSwizard::get_dwelltimes()]
}
