% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rSQLiteFunctions.R
\name{find.variants}
\alias{find.variants}
\title{Search variants in the reference database}
\usage{
find.variants(db.path, input.vector, column.name = "hID",
  reorder = FALSE, output.path = NULL)
}
\arguments{
\item{db.path}{character, full path to the database file (*.sqlite).}

\item{input.vector}{character, list of variant IDs to be searched in the database}

\item{column.name}{character, this can be either hID (CHR:POS:type) or ID (rsID). default: hID}

\item{reorder}{logical, if TRUE output is reordered like the input vector}

\item{output.path}{character, full path to the excel file.}
}
\value{
A data table is returned after searching for input variants in the database.
}
\description{
This function searches for a list of variants inside the reference database. rsID or hID of the variants can be used for the lookup.
}
\examples{
find.variants(system.file("extdata", "sample_db.sqlite", package = "GWASinspector"),
              c('rs568405545','rs367896724') , column.name = 'ID')

find.variants(system.file("extdata", "sample_db.sqlite", package = "GWASinspector"),
              c('1:10506:1','1:10511:1') , column.name = 'hID')

}
