% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmvi.R
\name{gmvi.fun}
\alias{gmvi.fun}
\title{Function for GVI and MVI}
\usage{
gmvi.fun(Y)
}
\arguments{
\item{Y}{a matrix of positive continuous random variables}
}
\value{
Returns a vector containing :
\item{gvi}{The generalized variation index}
\item{mvi}{The marginal variation index}
}
\description{
The function computes GVI and MVI indexes for multivariate positive continuous data.
}
\details{
\code{gmvi.fun} computes the GVI and MVI indexes defined in Kokonendji et al. (2020).
}
\examples{
Y<-cbind(c(2.3 ,26.1 ,8.7 ,10.9 ,1.2,1.4),c(9.7 ,7.3,9.3 ,9.4 ,10.5 ,9.8))
gmvi.fun(Y)
Z<-cbind(c(2.3 ,26.1 ,8.7),c(9.7 ,7.3,9.3),c(9.7 ,7.3,9.3),c(9.7 ,7.3,9.3))
gmvi.fun(Z)
}
\references{
Kokonendji, C.C., Touré, A.Y. and Sawadogo, A. (2020). Relative variation indexes for multivariate continuous distributions on \eqn{[0,\infty)^k} and extensions, \emph{AStA Advances in Statistical Analysis} \bold{104}, 285-307.
}
\author{
Aboubacar Y. Touré and Célestin C. Kokonendji
}
