% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NContributorsRule.R
\name{NContributorsRule}
\alias{NContributorsRule}
\title{Number of contributors suppression rule}
\usage{
NContributorsRule(
  data,
  freq,
  numVar,
  x,
  maxN = 3,
  protectZeros = FALSE,
  charVar = NULL,
  removeCodes = character(0),
  remove0 = TRUE,
  ...
)
}
\arguments{
\item{data}{Input data as a data frame}

\item{freq}{Vector of aggregate frequencies}

\item{numVar}{Numerical variables. When several variables, only first is used.}

\item{x}{Model matrix generated by parent function}

\item{maxN}{Primary suppression when number of contributors \verb{<= maxN}.}

\item{protectZeros}{Suppression parameter. Only TRUE (default) is used implemented.}

\item{charVar}{Variable with contributor codes.
When empty, unique contributor in each row is assumed.}

\item{removeCodes}{Vector of codes to be omitted when counting contributors.
With empty \code{charVar} row indices are assumed
and conversion to integer is performed.}

\item{remove0}{When \code{FALSE} (default), data rows where \code{numVar} (if any) is zero are omitted when counting contributors.}

\item{...}{unused parameters}
}
\value{
List where first element is logical vector defining primary suppressions.
The second element is data frame where \code{nRule} is number contributors used
in rule and where \code{nAll} is similar, but without omitting codes in \code{removeCodes}.
}
\description{
The number of contributors is the number unique contributing 'charVar' codes.
}
