% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LazyLinkedTables.R
\name{LazyLinkedTables}
\alias{LazyLinkedTables}
\title{Linked tables by full \code{\link{GaussSuppressionFromData}} iterations}
\usage{
LazyLinkedTables(..., withinArg = NULL, maxIterLinked = 1000)
}
\arguments{
\item{...}{Arguments to \code{GaussSuppressionFromData} that are kept constant.}

\item{withinArg}{A list of named lists. Arguments to \code{GaussSuppressionFromData} that are not kept constant.}

\item{maxIterLinked}{Maximum number of \code{GaussSuppressionFromData} calls for each table.}
}
\value{
List of data frames
}
\description{
\code{\link{AdditionalSuppression}} is called several times as in \code{\link{ChainedSuppression}}
}
\details{
This function is created as a spin-off from \code{AdditionalSuppression} and \code{ChainedSuppression}.
The calculations run \code{GaussSuppressionFromData} from the input each time.
There is no doubt that this can be done more efficiently.

A consequence of this lazy implementation is that, in output, \code{primary} and \code{suppressed} are identical.

Note that there is a residual risk when suppression linked tables by iterations.
}
\note{
In this function, the parameters \code{makeForced}  and \code{forceNotPrimary} to  \code{AdditionalSuppression} are forced to be \code{FALSE}.
}
\examples{

z1 <- SSBtoolsData("z1")
z2 <- SSBtoolsData("z2")
z2b <- z2[3:5]  # As in ChainedSuppression example 
names(z2b)[1] <- "region"

# The two region hierarchies as two linked tables
a <- LazyLinkedTables(z2, freqVar = 5, withinArg = list(
       list(dimVar = c(1, 2, 4)), 
       list(dimVar = c(1, 3, 4))))

# As 'f' and 'e' in ChainedSuppression example. 
# 'A' 'annet'/'arbeid' suppressed in b[[1]], since suppressed in b[[3]].
b <- LazyLinkedTables(withinArg = list(
       list(data = z1, dimVar = 1:2, freqVar = 3, maxN = 5), 
       list(data = z2b, dimVar = 1:2, freqVar = 3, maxN = 5), 
       list(data = z2, dimVar = 1:4, freqVar = 5, maxN = 1)))

}
