% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3methods_GeDSboost-GeDSgam.R
\name{visualize_boosting}
\alias{visualize_boosting}
\alias{visualize_boosting.GeDSboost}
\title{Visualize Boosting Iterations}
\usage{
\method{visualize_boosting}{GeDSboost}(object, iters = NULL, final_fits = FALSE)
}
\arguments{
\item{object}{a \code{\link{GeDSboost-Class}} object.}

\item{iters}{numeric, specifies the iteration(s) number.}

\item{final_fits}{logical indicating whether the final linear, quadratic and
cubic fits should be plotted.}
}
\description{
This function plots the \code{\link{NGeDSboost}} fit to the data at the
beginning of a given boosting iteration and then plots the subsequent
\code{\link{NGeDS}} fit on the corresponding residual (negative gradient).
Note: Applicable only for \code{\link{NGeDSboost}} models with one covariate
and \code{family = mboost::Gaussian()}.
}
\examples{
# Load packages
library(GeDS)

# Generate a data sample for the response variable
# Y and the single covariate X
set.seed(123)
N <- 500
f_1 <- function(x) (10*x/(1+100*x^2))*4+4
X <- sort(runif(N, min = -2, max = 2))
# Specify a model for the mean of Y to include only a component
# non-linear in X, defined by the function f_1
means <- f_1(X)
# Add (Normal) noise to the mean of Y
Y <- rnorm(N, means, sd = 0.2)
data = data.frame(X, Y)
Gmodboost <- NGeDSboost(Y ~ f(X), data = data, normalize_data = TRUE)

# Plot
plot(X, Y, pch=20, col=c("darkgrey"))
lines(X, sapply(X, f_1), col = "black", lwd = 2)
lines(X, Gmodboost$predictions$pred_linear, col = "green4", lwd = 2)
lines(X, Gmodboost$predictions$pred_quadratic, col="red", lwd=2)
lines(X, Gmodboost$predictions$pred_cubic, col="purple", lwd=2)
legend("topright",
legend = c("Order 2 (degree=1)", "Order 3 (degree=2)", "Order 4 (degree=3)"),
col = c("green4", "red", "purple"),
lty = c(1, 1),
lwd = c(2, 2, 2),
cex = 0.75,
bty="n",
bg = "white")
# Visualize boosting iterations + final fits
par(mfrow=c(4,2))
visualize_boosting(Gmodboost, iters = 0:3, final_fits = TRUE)
par(mfrow=c(1,1))

}
