% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.models.R
\name{compare.models}
\alias{compare.models}
\title{Compare gravity models}
\usage{
compare.models(...)
}
\arguments{
\item{...}{gravity model objects}
}
\value{
data.frame of competing model statistics
}
\description{
Prints diagnostic statistics for comparing gravity models
}
\details{
Results include model name, AIX, BIC, log likelihood, RMSE and number of parameters
}
\examples{
 
library(nlme)
  data(ralu.model)

x = c("DEPTH_F", "HLI_F", "CTI_F", "cti", "ffp")
( null <-  gravity(y = "DPS", x = c("DISTANCE"), d = "DISTANCE",  
                 group = "FROM_SITE", data = ralu.model, method = "ML") )

( gm_h1 <- gravity(y = "DPS", x = x, d = "DISTANCE", group = "FROM_SITE", 
                 data = ralu.model, ln = FALSE, method="ML") ) 
( gm_h2 <- gravity(y = "DPS", x = x[1:3], d = "DISTANCE", group = "FROM_SITE", 
                data = ralu.model, ln = FALSE, method="ML") ) 
( gm_h3 <- gravity(y = "DPS", x = x[c(4:5)], d = "DISTANCE", group = "FROM_SITE", 
                data = ralu.model, ln = FALSE, method="ML") ) 

compare.models(null, gm_h1, gm_h2, gm_h3)

}
\references{
Murphy M.A., R. Dezzani, D.S. Pilliod & A.S. Storfer (2010) Landscape genetics of 
  high mountain frog metapopulations. Molecular Ecology 19(17):3634-3649
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org> and 
        Melanie Murphy <melanie.murphy@uwyo.edu>
}
