% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_instances.R
\name{create_F}
\alias{create_F}
\title{Calculate the variant allele frequency (VAF) values in a set of samples}
\usage{
create_F(U, B, heterozygous = TRUE)
}
\arguments{
\item{U}{A matrix where each row corresponds to a sample, and each column corresponds to a clone. The value at the i-th row and j-th column is the frequency of the j-th clone in the i-th sample.}

\item{B}{A matrix representing the mutation relationships between the nodes in the phylogenetic tree.}

\item{heterozygous}{A logical value indicating whether to adjust the clone proportions for heterozygous states. If `TRUE`, the clone proportions are halved. If `FALSE`, the clone proportions are not adjusted. Default is `TRUE`.}
}
\value{
A matrix containing the VAF values of a series of mutations in a set of samples.
}
\description{
This method generates the F matrix that contains the mutation frequency values of a series of mutations in a collection of tumor biopsies or samples.
}
\examples{
# Create random topology with 10 nodes and k = 2
B <- create_B(10, 2)

# Create U matrix with parameter m=4 and "positive" selection
U <- create_U(B = B, m = 4, selection = "positive")

# Then we compute the F matrix for a heterozygous tumor
F <- create_F(U = U, B = B, heterozygous = TRUE)

}
