% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detection_probability_functions.R
\name{prepSS}
\alias{prepSS}
\title{Create search schedule data into an prepSS object for convenient 
 splits analyses}
\usage{
prepSS(data_SS, SSdate = NULL, preds = NULL)
}
\arguments{
\item{data_SS}{data frame or matrix with search schedule parameters,
including columns for search dates, covariates (describing characteristics
of the search intervals), and each unit (with 1s and 0s to indicate 
whether the given unit was searched (= 1) or not (= 0) on the given date)}

\item{SSdate}{name of the column with the search dates in it
(optional). If no \code{SSdate} is given, \code{prepSS} will
try to find the date column based on data formats. If there is exactly one
column that can be interpreted as dates, that column will be taken as the
dates searched. If more than one date column is found, \code{prepSS} exits
with an error message.}

\item{preds}{vector of character strings giving the names of columns to be
interpreted as potential covariates (optional). Typically, it is not
necessary for a user to provide a value for \code{preds}. It is used only
to identify specific columns of 1s and 0s as covariates rather than as
search schedules.}
}
\value{
\code{prepSS} object that can be conveniently used in the splitting
 functions.
}
\description{
Since data_SS columns largely have a specific, required
  format, the \code{prepSS} function can often automatically decipher the
  data, but the user may specify explicit instructions for parsing the data
  for safety if desired. If the data are formatted properly, the automatic
  parsing is reliable in most cases. There are two exceptions. (1) If
  there is more than one column with possible dates (formatted as formal
  dates (as class \code{Date}, \code{POSIXlt} or \code{POSIXct}) or
  character strings or factors that can be unambiguously interpreted as
  dates (with assumed format "2018-05-15" or "2018/5/15"). In that case,
  the user must specify the desired dates as \code{dateColumn}. (2) If
  there is a covariate column consisting entirely of 0s and 1s. In that
  case, the user must specify the column(s) in \code{covars}.
}
\examples{
 data(mock)
 prepSS(mock$SS)

}
