% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app_widgets.R
\name{app_widgets}
\alias{app_widgets}
\alias{dataInputWidget}
\alias{dataDownloadWidget}
\alias{modelInputWidget}
\alias{widgetMaker}
\alias{modelRunWidget}
\alias{preTextMaker}
\alias{modelOutputWidget}
\alias{splitButtonWidget}
\alias{modelSelectionWidget}
\alias{modelSelectionWidgetHeader}
\alias{modelSelectionWidgetRow}
\alias{kFixedWidget}
\alias{kFixedWidgetHeader}
\alias{kFixedWidgetRow}
\title{Create and manage widgets for data input, function execution, data output}
\usage{
dataInputWidget(dataType)

dataDownloadWidget(set)

modelInputWidget(inType)

widgetMaker(Condition, Name, Fun, Label, Args)

modelRunWidget(modType)

preTextMaker(modType)

modelOutputWidget(modType)

splitButtonWidget()

modelSelectionWidget(mods, modType)

modelSelectionWidgetHeader(mods)

modelSelectionWidgetRow(mods, modType, sci)

kFixedWidget(sizeclasses)

kFixedWidgetHeader(sizeclasses)

kFixedWidgetRow(sizeclasses, sci)
}
\arguments{
\item{dataType}{Toggle control for the model type of the widget. One of 
"SE", "CP", "SS", "DWP", or "CO".}

\item{set}{Name of data set. One of "RP", "RPbat", "cleared", "powerTower",
"PV", "trough", "mock"}

\item{inType}{Toggle control for the input type of the widget. One of
"nsim", "CL", "class", "obsSE", "predsSE", "kFixed", "ltp", "fta",
"predsCP", "dist", "xID", "frac", "DWPCol", "COdate", "gSearchInterval", or
"gSearchMax".}

\item{Condition}{Condition under which the widget is present to the user.}

\item{Name}{Name (id) of the widget created.}

\item{Fun}{Function name (as character) used to create the widget.}

\item{Label}{Label presented to the user in the UI for the widget.}

\item{Args}{List of any additional arguments to be passed to the widget
creating function.}

\item{modType}{Toggle control for the model type of the widget. One of
"SE", "CP", "M", or "g".}

\item{mods}{Model Set Size object (from the reactive values list).}

\item{sci}{Name of carcass class element}

\item{sizeclasses}{Vector of carcass class names (from the reactive values
list).}
}
\value{
HTML for the data input widget.
}
\description{
This is a generalized function for creating a data input 
  widget used in the GenEst GUI, based on the data type (\code{dataType}).
  Included within the widget is a conditional panel that allows removal of
  the specific data file (and clearing of all downstream models) once
  it has been loaded.
}
