% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_frequencies.R
\name{plot_frequencies}
\alias{plot_frequencies}
\title{Plot the frequencies of all ancestors along the genome.}
\usage{
plot_frequencies(
  result,
  locations = seq(0, 1, length.out = 100),
  progress_bar = FALSE
)
}
\arguments{
\item{result}{An object which is the result of \code{select_population} or
\code{create_population_selection}, being a list with four properties:
\code{population}, \code{frequencies}, \code{initial_frequencies} and
\code{final frequencies}}

\item{locations}{A vector indicating the locations (in Morgan) where to
calculate the allele frequencies.}

\item{progress_bar}{Displays a progress_bar if TRUE. Default value is FALSE}
}
\value{
a ggplot2 object
}
\description{
This function plots the frequency of all ancestors after
performing a simulation.
}
\examples{
pop <- simulate_admixture(
             module = ancestry_module(number_of_founders = 4),
             pop_size = 1000,
             total_runtime = 11)
require(ggplot2)
plot_frequencies(result = pop)
}
