% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SGAT.R
\name{refracted}
\alias{refracted}
\title{Atmospheric Refraction}
\usage{
refracted(zenith)
}
\arguments{
\item{zenith}{zenith angle (degrees) to adjust.}
}
\value{
vector of zenith angles (degrees) adjusted for atmospheric
refraction.
}
\description{
Adjust the solar zenith angle for atmospheric refraction.
}
\details{
Given a vector of solar zeniths computed by \code{\link{zenith}},
\code{refracted} calculates the solar zeniths adjusted for the
effect of atmospheric refraction.

\code{unrefracted} is the inverse of \code{refracted}. Given a
(single) solar zenith adjusted for the effect of atmospheric
refraction, \code{unrefracted} calculates the solar zenith as
computed by \code{\link{zenith}}.
}
\examples{
## Refraction causes the sun to appears higher on the horizon
refracted(85:92)
## unrefracted gives unadjusted zenith (see SGAT)
}

