% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/others.R
\name{geo_dist}
\alias{geo_dist}
\title{Geodesic distance between two points on a manifold}
\usage{
geo_dist(manifold, p1, p2)
}
\arguments{
\item{manifold}{Type of manifold (\code{'euclidean'}, \code{'sphere'}, or
\code{'kendall'}).}

\item{p1}{A vector (or column matrix) representing a point on the manifold.}

\item{p2}{A vector (or column matrix) representing a point on the manifold.}
}
\value{
Riemannian distance between \code{p1} and \code{p2}.
}
\description{
Finds the Riemannian distance
\eqn{d(p_1,p_2)=||\textrm{Log}_{p_1}(p_2)||} between two points on
the given manifold, provided \eqn{p_2} is in the domain of
\eqn{\textrm{Log}_{p_1}}.
}
\details{
On the sphere, \eqn{-p_1} is not in the domain of \eqn{\textrm{Log}_{p_1}}.
}
\examples{
p1 <- matrix(rnorm(10), ncol = 2)
p1 <- p1[, 1] + (1i) * p1[, 2]
p1 <- (p1 - mean(p1)) / norm(p1 - mean(p1), type = '2')
p2 <- matrix(rnorm(10), ncol = 2)
p2 <- p2[, 1] + (1i) * p2[, 2]
p2 <- (p2 - mean(p2)) / norm(p2 - mean(p2), type = '2')
geo_dist('kendall', p1, p2)

}
\seealso{
\code{\link{log_map}}.
}
\author{
Ha-Young Shin
}
