% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxGrobs.R
\name{connectGrob}
\alias{connectGrob}
\alias{print.connect_boxes}
\alias{plot.connect_boxes}
\title{Connect boxes with an arrow}
\usage{
connectGrob(start, end, type = c("vertical", "horizontal", "L", "-", "Z",
  "N"), subelmnt = c("right", "left"), lty_gp = getOption("connectGrob",
  default = gpar(fill = "black")), arrow_obj = getOption("connectGrobArrow",
  default = arrow(ends = "last", type = "closed")))

\method{print}{connect_boxes}(x, ...)

\method{plot}{connect_boxes}(x, ...)
}
\arguments{
\item{start}{The start box}

\item{end}{The end box}

\item{type}{How the boxes are stacked. The \code{L} alternative generates a
straight line up/down and then turns to righT/left for connecting with the end.
The \code{-} generates a straight horizontal arrow. The \code{Z} creates a
horizontal line that looks like a \code{Z} with 90 degree turns. The option
\code{N} allows for vertical lines.}

\item{subelmnt}{If we have a split box we can specify the right/left x as the
connector point.}

\item{lty_gp}{The \code{\link[grid]{gpar}} for the line. Set
\code{connectGrob} option if you want to customize all the arrows at once.}

\item{arrow_obj}{The arrow spec according to \code{\link[grid]{arrow}}. Set
\code{connectGrobArrow} option if you want to customize all the arrows at once.}

\item{x}{The grob to print/plot}

\item{...}{Passed to \code{\link[grid]{grid.draw}}}
}
\value{
grob with an arrow
}
\description{
The function creates a grob that links two boxes together. It looks for
which side it should attach the arrow, e.g. if the start is on top of
the bottom it should attach to the bottom edge of ther start box and then
to the top at the end.

The print/plot calls the \code{\link[grid]{grid.draw}} function on the object
}
\details{
The exact positions of the line is stored at the \code{attr(..., "line")}.
If you want to draw your own custom line all you need to do is check which
\code{attr(my_line, "line")$x} and \code{attr(my_line, "line")$y} you want
to attach to and then create your own custom \code{\link[grid]{linesGrob}}.
}
\examples{
library(grid)
grid.newpage()

# Initiate the boxes that we want to connect
start <- boxGrob("Top", x=.5, y=.8)
end <- boxGrob("Bottom", x=.5, y=.2)
side <- boxPropGrob("Side", "Left", "Right", prop=.3, x=.2, y=.8)
sub_side_left <- boxGrob("Left", x = attr(side, "coords")$left_x, y = .5)
sub_side_right <- boxGrob("Right", x = attr(side, "coords")$right_x, y = .5)
exclude <- boxGrob("Exclude:\\n - Too sick\\n - Prev. surgery", x=.8, y=.5,just="left")

# Connect the boxes and print/plot them
connectGrob(start, end, "vertical")
connectGrob(start, side, "horizontal")
connectGrob(side, sub_side_left, "v", "l")
connectGrob(side, sub_side_right, "v", "r")
connectGrob(start, exclude, "L")

# Print the grobs
start
end
side
exclude
sub_side_left
sub_side_right
}
\seealso{
Other box-functions: \code{\link{boxGrob}},
  \code{\link{boxPropGrob}}
}
