% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxGrobs.R
\name{boxGrob}
\alias{boxGrob}
\alias{widthDetails.box}
\alias{heightDetails.box}
\alias{print.box}
\alias{plot.box}
\title{Create a box with text}
\usage{
boxGrob(
  label,
  y = unit(0.5, "npc"),
  x = unit(0.5, "npc"),
  width,
  height,
  just = "center",
  bjust = "center",
  txt_gp = getOption("boxGrobTxt", default = gpar(color = "black")),
  box_gp = getOption("boxGrob", gpar(fill = "#D8F0D1")),
  name = NULL
)

\method{widthDetails}{box}(x)

\method{heightDetails}{box}(x)

\method{print}{box}(x, ...)

\method{plot}{box}(x, ...)
}
\arguments{
\item{label}{The label to print - should be a number, text or expression.}

\item{y}{The y position to put the box at. Can be either in \code{npc} (i.e. 0-1) or a \code{\link[grid]{unit}}.}

\item{x}{The x position to put the box at. Can be either in \code{npc} (i.e. 0-1) or a \code{\link[grid]{unit}}.}

\item{width}{The box autosizes but you can force by specifying the width}

\item{height}{The box autosizes but you can force by specifying the height}

\item{just}{The justification for the text: left, center or right.}

\item{bjust}{The justification for the box: left, center, right, top or bottom.
See the \code{just} option for the \code{\link[grid]{viewport}}}

\item{txt_gp}{The \code{\link[grid]{gpar}} style to apply to the text. Set \code{boxGrobTxt} option
if you want to customize all the boxes at once.}

\item{box_gp}{The \code{\link[grid]{gpar}} style to apply to the box. Set \code{boxGrob} option
if you want to customize all the boxes at once.}

\item{name}{a character identifier for the grob. Used to find the grob on the display
list and/or as a child of another grob.}

\item{...}{Passed to \code{\link[grid]{grid.draw}}}
}
\value{
A grob
}
\description{
Creates a grob box with text inside it.
}
\examples{
library(grid)
grid.newpage()
boxGrob("My box")
}
\seealso{
Other box-functions: 
\code{\link{boxPropGrob}()},
\code{\link{connectGrob}()}
}
\concept{box-functions}
