% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bezier_private_functions.R
\name{getAbsoluteWidth}
\alias{getAbsoluteWidth}
\title{Translates "npc" widths into absolute units}
\usage{
getAbsoluteWidth(w, default.units, x = x, y = y)
}
\arguments{
\item{w}{The width that is to be changed}

\item{default.units}{A string indicating the default units to use
    if \code{x} or \code{y}
    are only given as numeric vectors.}

\item{x}{A numeric vector or unit object specifying x-locations of
    spline control points.}

\item{y}{A numeric vector or unit object specifying y-locations of
    spline control points.}
}
\value{
The width transformed into a \code{\link[grid]{unit}} of "mm"
}
\description{
The "npc" \code{\link[grid]{unit}} is not absolute, i.e.
it depends on the relation between height and  width within
the current viewport. We therefore need to change these values
to the value most likely intended. This is believed to be the
main direction of the arrow as specified by the first and last
bezier control points \code{x} and \code{y}.
}
\keyword{internal}
