% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDescriptionStatsBy_prAddDescStats.R
\name{prAddDescStats}
\alias{prAddDescStats}
\title{Add a p-value column to the results}
\usage{
prAddDescStats(
  results,
  x,
  by,
  statistics,
  statistics.suppress_warnings,
  statistics.sig_lim,
  statistics.two_dec_lim,
  html
)
}
\arguments{
\item{results}{The results that we want to add the column to}

\item{x}{If a data.frame it will be used as the data source for the variables in the \code{...} parameter.
If it is a single variable it will be the core value that want the statistics for.
In the print this is equivalent to the output of this function.}

\item{by}{The variable that you want to split into different columns}

\item{statistics}{Add statistics, fisher test for proportions and Wilcoxon
for continuous variables. See details below for more customization.}

\item{statistics.suppress_warnings}{Hide warnings from the statistics function.}

\item{statistics.sig_lim}{The significance limit for < sign, i.e. p-value 0.0000312
should be < 0.0001 with the default setting.}

\item{statistics.two_dec_lim}{The limit for showing two decimals. E.g.
the p-value may be 0.056 and we may want to keep the two decimals in order
to emphasize the proximity to the all-mighty 0.05 p-value and set this to
\eqn{10^-2}. This allows that a value of 0.0056 is rounded to 0.006 and this
makes intuitive sense as the 0.0056 level as this is well below
the 0.05 value and thus not as interesting to know the exact proximity to
0.05. \emph{Disclaimer:} The 0.05-limit is really silly and debated, unfortunately
it remains a standard and this package tries to adapt to the current standards in order
to limit publication associated issues.}

\item{html}{If HTML compatible output should be used. If \code{FALSE}
it outputs LaTeX formatting}
}
\value{
results with added column
}
\description{
Add a p-value column to the results
}
