% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{matern_space_time}
\alias{matern_space_time}
\title{Space-time Matern-covariance function}
\usage{
matern_space_time(covparms, locstime)
}
\arguments{
\item{covparms}{A vector giving positive-valued covariance parameters
in the form (variance, spatial range, temporal range, smoothness, nugget)}

\item{locstime}{A matrix with \code{n} rows and d+1 columns. The first d columns
give a location in R^d, and the last column gives a time. Each row corresponds
to a space-time location.}
}
\value{
A matrix with \code{n} rows and \code{n} columns, with the \code{i,j} entry
containing the covariance between observations at \code{locstime[i,]} and
\code{locstime[j,]}.
}
\description{
From a matrix of locations and times and a vector covariance parameters of the form
(variance, spatial range, temporal range, smoothness, nugget), return the square matrix of
all pairwise covariances.
}
