% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{vecchia_Linv}
\alias{vecchia_Linv}
\title{Entries of inverse Cholesky approximation}
\usage{
vecchia_Linv(covparms, covfun_name, locs, NNarray, start_ind = 1L)
}
\arguments{
\item{covparms}{A vector of covariance parameters appropriate
for the specified covariance function}

\item{covfun_name}{See \code{\link{GpGp}} for information about covariance
functions.}

\item{locs}{matrix of locations. Row \code{i} of \code{locs} specifies the location
of element \code{i} of \code{y}, and so the length of \code{y} should equal
the number of rows of \code{locs}.}

\item{NNarray}{A matrix of indices, usually the output from \code{\link{find_ordered_nn}}.
Row \code{i} contains the indices
of the observations that observation \code{i} conditions on. By convention,
the first element of row \code{i} is \code{i}.}

\item{start_ind}{Compute entries of Linv only for rows \code{start_ind}
until the last row.}
}
\value{
matrix containing entries of inverse Cholesky
}
\description{
This function returns the entries of the inverse Cholesky
factor of the covariance matrix implied by Vecchia's approximation.
For return matrix \code{Linv}, \code{Linv[i,]} contains 
the non-zero entries of row \code{i} of
the inverse Cholesky matrix. The columns of the non-zero entries
are specified in \code{NNarray[i,]}.
}
\examples{
n1 <- 40
n2 <- 40
n <- n1*n2
locs <- as.matrix( expand.grid( (1:n1)/n1, (1:n2)/n2 ) )
covparms <- c(2, 0.2, 0.75, 0)
NNarray <- find_ordered_nn(locs,20)
Linv <- vecchia_Linv(covparms, "matern_isotropic", locs, NNarray)
}
