% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCrudeAndAdjustedModelData.R
\name{getCrudeAndAdjustedModelData}
\alias{getCrudeAndAdjustedModelData}
\alias{[.getCrudeAndAdjustedModelData}
\title{This function helps with printing regression models}
\usage{
getCrudeAndAdjustedModelData(
  model,
  level = 0.95,
  remove_interaction_vars = TRUE,
  remove_strata = FALSE,
  remove_cluster = FALSE,
  var_select,
  ...
)

\method{[}{getCrudeAndAdjustedModelData}(x, i, j, ...)
}
\arguments{
\item{model}{The regression model}

\item{level}{The confidence interval level}

\item{remove_interaction_vars}{Removes the interaction terms as they in
the raw state are difficult to understand}

\item{remove_strata}{Strata should most likely not be removed in the crude
version. If you want to force the removal of stratas you can specify the
\code{remove_strata = TRUE}}

\item{remove_cluster}{Cluster information should most likely also retain
just as the \code{remove_strata} option. Clusters are sometimes used in
cox regression models, \code{\link[survival]{cluster}()}}

\item{var_select}{A vector with regular expressions for choosing what variables
to return (the same format as for the \code{order} argument in
\code{\link{printCrudeAndAdjustedModel}()} call). It can be useful when working with
large datasets only to report a subsection of all tested variables. This
makes the function both run faster and the data presentation more concise.}

\item{...}{Not used}
}
\value{
Returns a matrix with the columns:
  \code{c("Crude", "2.5 \%", "97.5 \%", "Adjusted", "2.5 \%", "97.5 \%")}.
  The row order is not changed from the original model. The percentages can vary depending
  on the set level.
}
\description{
This function is used for getting the adjusted and unadjusted values
for a regression model. It takes a full model and walks through each
variable, removes in the regression all variables except one then
reruns that variable to get the unadjusted value. This functions not
intended for direct use, it's better to use \code{\link{printCrudeAndAdjustedModel}()}
that utilizes this function.
}
\details{
This function saves a lot of time creating tables since it compiles a fully
unadjusted list of all your used covariates.

If the model is an exponential poisson/logit/cox regression model then it automatically
reports the exp() values instead of the original values

The function skips by default all spline variables since this becomes very complicated
and there is no simple \deqn{\beta}{beta} to display. For the same reason it skips
any interaction variables since it's probably better to display these as a contrast table.

Note that the rms regression has a separate function that uses the \code{rms:::summaryrms} function
that returns a matrix that is then pruned.
}
\examples{
# simulated data to use
set.seed(10)
ds <- data.frame(
  ftime = rexp(200),
  fstatus = sample(0:1, 200, replace = TRUE),
  x1 = runif(200),
  x2 = runif(200),
  x3 = runif(200),
  x4 = runif(200),
  x5 = runif(200)
)

library(rms)
dd <- datadist(ds)
options(datadist = "dd")

s <- Surv(ds$ftime, ds$fstatus == 1)
fit <- cph(s ~ x1 + x2 + x3, data = ds)

data_matrix <- getCrudeAndAdjustedModelData(fit)

print(data_matrix)

# If we have interaction then those variable are not
# reported
fit <- cph(s ~ x1 + x2 + x3 + x4 * x5, data = ds)
data_matrix <- getCrudeAndAdjustedModelData(fit)

print(data_matrix)
}
\seealso{
\code{\link{printCrudeAndAdjustedModel}()}

Other crudeAndAdjusted functions: 
\code{\link{printCrudeAndAdjustedModel}()}
}
\concept{crudeAndAdjusted functions}
\keyword{internal}
