package de.fhg.iais.kd.gridr.interfaces.acgt;

import java.util.Vector;

import gr.forth.ics.enactapi.EnactmentAPI;
import gr.forth.ics.enactapi.parameter.*;
import gr.forth.ics.enactapi.status.RunningStatus;

public class AcgtEnactor {
	
	public static void main(String[] args) {
		//input: urn:eu-acgt.org:service:columnappender "[input_csv 7276]" janedoe myproxy.custodix.com magneticpig NULL NULL
		if(args.length!=5){
			System.out.println("wrong usage: id param myProxyUsername myProxyPasswd myProxyCredentialName");
			return;
		}
		String wfid = args[0]; //"urn:eu-acgt.org:service:columnappender"
		String paramStr = args[1];// "[input_csv 7276]
		String user = args[2]; //"janedoe"
		String passwd = args[3]; //"magneticpig"
		String credName = args[4];
	
		//parse paramStr
		String[] splitParam = paramStr.split("\\[");
		Vector<Parameter> params = new Vector<Parameter>();
		for(String param : splitParam){
			if(param.length()==0)
				continue;
			if(param.charAt(param.length()-1)==']')
				param = param.substring(0, param.length()-1);//ignore ] at the end of the string
			
			if(param.contains("{") && param.contains("}")){
				//found an StringArrayParam ie: 1 {a b}
				String[] tmp = param.split("\\{");
				//now tmp[0] should contain the name and only one entry
				if(!tmp[0].endsWith(" ") && tmp[0].split(" ").length!=1){
					System.out.println("Error, wrong syntax. A StringArrayParameter must start with the name, followed by an array");
					return;
				}
				String name = tmp[0].trim();
				if(tmp[1].charAt(tmp[1].length()-1)=='}')
					tmp[1] = tmp[1].substring(0, param.length()-1);//ignore } at the end of the string
				//tmp[1] ie. "a b"
				String[] values = tmp[1].split(" ");
				
				params.add(new StringArrayParameter(name, values));
			}
			else //found a StringParam ie: "test 23123"
			{
				String[] tmp = param.split(" ");
				if(tmp.length!=2){
					System.out.println("Error, wrong syntax. A simple fileInput entry contains ParameterName and DmsFileID ");
					return;
				}
				String name = tmp[0];
				String value = tmp[1];
				//System.out.println(name + " "+ value);
				params.add(new StringParameter(name, value));
			}
		}
		try{
			Parameter[] paramA = new Parameter[params.size()];
			params.toArray(paramA);
																	// finally: http://iapetus.ics.forth.gr:8080/servlet/EnactorProxy
			EnactmentAPI e = new EnactmentAPI(user, passwd, "http://iapetus.ics.forth.gr:8080/servlet/EnactorProxy");
	
			//TODO add credentialName
			String op = "execute";
			//Parameter dir = EnactmentAPI.createStringParam("input_csv", "7276");
			//Parameter[] paramA = new Parameter[] { dir};
			String enactID = e.enact(wfid, op, paramA);
			RunningStatus st = e.getStatus(enactID);
			//Parameter mids = EnactmentAPI.createStringArrayParam("mids", new String[] {"mid-1", "mid-2" });
			
			while (st !=RunningStatus.FINISHED && st != RunningStatus.FAILED) {
				//System.out.println("Enactment Status:"+ st);
				Thread.sleep(10000);
				st = e.getStatus(enactID);
			}
	
			if (st != RunningStatus.FAILED){
	
				Parameter[] results = e.getResults(enactID);
				for (int i=0 ; results!= null && i<results.length; ++i){
					if (! results[i].isMultiValuedParameter()){
						//System.out.println("param["+i+"='"+results[i].getName()+"']="+results[i].getValueAsString());
						Vector<String> result = new Vector<String>();
						result.add(results[i].getName());
						result.add(results[i].getValueAsString());
						System.out.println(result);
					}else{
						String[] values = results[i].getValueAsStringArray();
						//System.out.println("param["+i+"='"+results[i].getName()+"']= : ");
						Vector<String> result = new Vector<String>();
						result.add(results[i].getName());
						for (int j=0 ; j<values.length; ++j){
							//System.out.println("\tvalue["+j+"]="+values[j]);
							result.add(values[j]);
						}
						System.out.println(result);
					}
				}
			}
			else
				System.out.println("Enactment failed");
		}
		catch(Exception e){
			System.out.println("Error, cannot enact the specified service: \n"+ e.getMessage() + "\n");
			e.printStackTrace();
		}
	}
	
}