% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{process_pattern}
\alias{process_pattern}
\title{Extract and Process Pattern-Matched Variables (Internal)}
\usage{
process_pattern(pattern, data_obj, exp_name, pattern_mix = FALSE)
}
\arguments{
\item{pattern}{Character. The pattern to match against dimension structures.}

\item{data_obj}{An SL4 or HAR object containing dimension information and data.}

\item{exp_name}{Character. The experiment name assigned to the extracted data.}

\item{pattern_mix}{Logical. If \code{TRUE}, allows pattern matching to ignore dimension order.}
}
\value{
A data frame containing processed data for the matching pattern, or \code{NULL} if no matches are found.
}
\description{
A helper function that extracts and processes variables matching a specified pattern
within an SL4 or HAR data object. Used internally in \code{get_data_by_dims()}.
}
\details{
\itemize{
\item Searches for variables whose dimension structures match the given pattern.
\item Supports flexible pattern matching when \code{pattern_mix = TRUE}, allowing dimension order to vary.
\item Extracted data is converted into a tidy format, preserving dimension structures.
\item Standardizes \code{"Subtotal"} column naming for consistency across datasets.
\item Ensures only non-empty extracted variables are retained.
}
}
\seealso{
\code{\link{get_original_pattern}}, \code{\link{pattern_match}}, \code{\link{get_data_by_dims}}
}
\author{
Pattawee Puangchit
}
\keyword{internal}
