% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_HARplus.R
\name{load_harplus}
\alias{load_harplus}
\title{Load and Process GEMPACK HAR Files (Internal)}
\usage{
load_harplus(con, coefAsname = FALSE, lowercase = TRUE, select_header = NULL)
}
\arguments{
\item{con}{Character or connection. The file path to the HAR file or an open binary connection.}

\item{coefAsname}{Logical. If \code{TRUE}, replaces four-letter headers with coefficient names when available. Default is \code{FALSE}.}

\item{lowercase}{Logical. If \code{TRUE}, converts all string values to lowercase. Default is \code{TRUE}.}

\item{select_header}{Character vector. Specific headers to extract; if \code{NULL}, reads all headers.}
}
\value{
A structured list where:
\itemize{
\item Each element corresponds to a header in the HAR file.
\item Names are either header names or coefficient names (if \code{coefAsname = TRUE}).
\item Data maintains its original dimensions and attributes.
}
}
\description{
Reads a GEMPACK HAR file and efficiently extracts structured data while maintaining
compatibility with standard HAR formats. This implementation builds upon the foundational
work of the \strong{HARr} package, reorganizing the process for improved execution speed,
memory management, and handling of sparse data structures.
}
\details{
\itemize{
\item \strong{Efficient File Reading:} Reads large HAR files in chunks for better performance.
\item \strong{Optimized Memory Usage:} Reduces unnecessary allocations and improves cleanup.
\item \strong{Streamlined Header Processing:} Ensures accurate extraction of dimension metadata.
\item \strong{Supports Sparse Data Structures:} Handles \code{RESPSE} and \code{REFULL} headers efficiently.
}

\strong{Supported HAR Header Types:}
\itemize{
\item \verb{1CFULL}: Character headers
\item \verb{2IFULL}: Integer headers
\item \verb{2RFULL}: Real headers
\item \code{REFULL}: Real headers with extended metadata
\item \code{RESPSE}: Sparse real headers
}
}
\seealso{
\code{\link{load_sl4x}}, \code{\link{load_harx}}
}
\author{
Pattawee Puangchit
}
\keyword{internal}
