% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ESAC.R
\name{ESAC_test_calibrate}
\alias{ESAC_test_calibrate}
\title{Generates empirical penalty function \eqn{\gamma(t)} for single change-point testing using Monte Carlo simulation}
\usage{
ESAC_test_calibrate(
  n,
  p,
  bonferroni = TRUE,
  N = 1000,
  tol = 1/1000,
  fast = FALSE,
  rescale_variance = TRUE,
  debug = FALSE
)
}
\arguments{
\item{n}{Number of observations}

\item{p}{Number time series}

\item{bonferroni}{If \code{TRUE}, a Bonferroni correction applied and the empirical penalty function \eqn{\gamma(t)} is chosen by simulating leading constants of \eqn{r(t)} through Monte Carlo simulation.}

\item{N}{Number of Monte Carlo samples used}

\item{tol}{False positive probability tolerance}

\item{fast}{If \code{TRUE}, ESAC only tests for a change-point at the midpoint of the interval \eqn{(0,\ldots,n]}}

\item{rescale_variance}{If \code{TRUE}, each row of the data is re-scaled by a MAD estimate using \code{\link{rescale_variance}}}

\item{debug}{If \code{TRUE}, diagnostic prints are provided during execution}
}
\value{
A list containing a vector of values of \eqn{\gamma(t)} for \eqn{t \in \mathcal{T}} decreasing (element #1), a vector of corresponding values of the threshold \eqn{a(t)} (element # 3), a vector of corresponding values of \eqn{\nu_{a(t)}}

A list containing 
  \item{without_partial}{ a vector of values of \eqn{\gamma(t)} for \eqn{t \in \mathcal{T}} decreasing in \eqn{t}}
  \item{with_partial}{same as \code{without_partial}}
  \item{as}{vector of threshold values \eqn{a(t)} for \eqn{t \in \mathcal{T}} decreasing in \eqn{t}}
  \item{nu_as}{vector of conditional expectations \eqn{\nu_{a(t)}} of a thresholded Gaussian, for \eqn{t \in \mathcal{T}} decreasing in \eqn{t}}
}
\description{
R wrapper for C function choosing the penalty function \eqn{\gamma(t)} by Monte Carlo simulation, as described in Appendix B in \insertCite{moen2023efficient;textual}{HDCD}, for testing for a single change-point.
}
\examples{
library(HDCD)
n = 50
p = 50

set.seed(100)
thresholds_emp = ESAC_test_calibrate(n,p, bonferroni=TRUE,N=100, tol=1/100)
set.seed(100)
thresholds_emp_without_bonferroni = ESAC_test_calibrate(n,p, bonferroni=FALSE,N=100, tol=1/100)
thresholds_emp[[1]] # vector of \gamma(t) for t = p,...,1
thresholds_emp_without_bonferroni[[1]] # vector of \gamma(t) for t = p,...,1

# Generating data
X = matrix(rnorm(n*p), ncol = n, nrow=p)
Y = matrix(rnorm(n*p), ncol = n, nrow=p)

# Adding a single sparse change-point to X (and not Y):
X[1:5, 26:n] = X[1:5, 26:n] +2
resX = ESAC_test(X, thresholds = thresholds_emp[[1]])
resX
resY = ESAC_test(Y,  thresholds = thresholds_emp[[1]])
resY
}
\references{
\insertAllCited{}
}
