% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changepoint_test_Pilliat.R
\name{Pilliat_test}
\alias{Pilliat_test}
\title{Pilliat single change-point test}
\usage{
Pilliat_test(
  X,
  empirical = FALSE,
  N = 100,
  tol = 0.05,
  thresholds_partial = NULL,
  threshold_dense = NULL,
  thresholds_bj = NULL,
  threshold_d_const = 4,
  threshold_bj_const = 6,
  threshold_partial_const = 4,
  rescale_variance = TRUE,
  fast = FALSE,
  debug = FALSE
)
}
\arguments{
\item{X}{Matrix of observations, where each row contains a time series}

\item{empirical}{If \code{TRUE}, detection thresholds are based on Monte Carlo simulation}

\item{N}{If \code{empirical=TRUE}, \code{N} is the number of Monte Carlo samples used}

\item{tol}{If \code{empirical=TRUE}, \code{tol} is the false error probability tolerance}

\item{thresholds_partial}{Vector of manually specified detection thresholds for the partial sum statistic, for sparsities/partial sums \eqn{t=1,2,4,\ldots,2^{\lfloor\log_2(p)\rfloor}}}

\item{threshold_dense}{Manually specified value of detection threshold for the dense statistic}

\item{thresholds_bj}{Vector of manually specified detection thresholds for the Berk-Jones statistic, order corresponding to \eqn{x=1,2,\ldots,x_0}}

\item{threshold_d_const}{Leading constant for the analytical detection threshold for the dense statistic}

\item{threshold_bj_const}{Leading constant for \eqn{p_0} when computing the detection threshold for the Berk-Jones statistic}

\item{threshold_partial_const}{Leading constant for the analytical detection threshold for the partial sum statistic}

\item{rescale_variance}{If \code{TRUE}, each row of the data is re-scaled by a MAD estimate (see \code{\link{rescale_variance}})}

\item{fast}{If \code{TRUE}, only the mid-point of \eqn{(0,\ldots,n]} is tested for a change-point. Otherwise a test is performed at each candidate change-point poisition}

\item{debug}{If \code{TRUE}, diagnostic prints are provided during execution}
}
\value{
1 if a change-point is detected, 0 otherwise
}
\description{
R wrapper function testing for a single change-point using the three test statistics in the multiple change point detection algorithm of \insertCite{pilliat_optimal_2022;textual}{HDCD}. See also Appendix E in \insertCite{moen2023efficient;textual}{HDCD}.
}
\examples{
library(HDCD)
n = 200
p = 200

# Generating data
X = matrix(rnorm(n*p), ncol = n, nrow=p)
Y = matrix(rnorm(n*p), ncol = n, nrow=p)

# Adding a single sparse change-point to X (and not Y):
X[1:5, 100:200] = X[1:5, 100:200] +1

# Vanilla Pilliat test:
resX = Pilliat_test(X)
resX
resY = Pilliat_test(Y)
resY

# Manually setting leading constants for the theoretical thresholds for the three 
# test statistics used
resX = Pilliat_test(X, 
                    threshold_d_const=4, 
                    threshold_bj_const=6, 
                    threshold_partial_const=4
)
resX 
resY = Pilliat_test(Y, 
                    threshold_d_const=4, 
                    threshold_bj_const=6, 
                    threshold_partial_const=4
)
resY

# Empirical choice of thresholds:
resX = Pilliat_test(X, empirical = TRUE, N = 100, tol = 1/100)
resX
resY = Pilliat_test(Y, empirical = TRUE, N = 100, tol = 1/100)
resY

# Manual empirical choice of thresholds (equivalent to the above)
thresholds_test_emp = Pilliat_test_calibrate(n,p, N=100, tol=1/100,bonferroni=TRUE)
resX = Pilliat_test(X, 
                    threshold_dense=thresholds_test_emp$threshold_dense, 
                    thresholds_bj = thresholds_test_emp$thresholds_bj, 
                    thresholds_partial = thresholds_test_emp$thresholds_partial
)
resX
resY = Pilliat_test(Y, 
                    threshold_dense=thresholds_test_emp$threshold_dense, 
                    thresholds_bj = thresholds_test_emp$thresholds_bj, 
                    thresholds_partial = thresholds_test_emp$thresholds_partial
)
resY
}
\references{
\insertAllCited{}
}
