% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/T_alpha_statistics.R
\name{test_MVSP}
\alias{test_MVSP}
\title{Test for mean-variance portfolio weights}
\usage{
test_MVSP(gamma, x, w_0, beta = 0.05)
}
\arguments{
\item{gamma}{a numeric variable. Coefficient of risk aversion.}

\item{x}{a p by n matrix or a data frame of asset returns. Rows represent different
assets, columns -- observations.}

\item{w_0}{a numeric vector of tested weights.}

\item{beta}{a confidence level for the test.}
}
\value{
\tabular{ll}{
   Element \tab Description \cr
   alpha_hat \tab the estimated shrinkage intensity \cr
   alpha_sd \tab the standard deviation of the shrinkage intensity \cr
   alpha_lower \tab the lower bound for the shrinkage intensity \cr
   alpha_upper \tab the upper bound for the shrinkage intensity \cr
   T_alpha \tab the value of the test statistic \cr
   p_value \tab the p-value for the test \cr
}
}
\description{
A high-dimensional asymptotic test on the mean-variance efficiency of a given
portfolio with the weights \eqn{\rm{w}_0}. The tested hypotheses are
\deqn{H_0: w_{MV} = w_0 \quad vs \quad H_1: w_{MV} \neq w_0.}
The test statistic is based on the shrinkage estimator of mean-variance portfolio weights
\insertCite{@see Eq.(44) of @BDOPS2021}{HDShOP}.
}
\details{
Note: when gamma == Inf, we get the test for the weights of the global minimum
variance portfolio as in Theorem 2 of \insertCite{BDPS2019;textual}{HDShOP}.
}
\examples{
n<-3e2 # number of realizations
p<-.5*n # number of assets
b<-rep(1/p,p)
gamma<-1

x <- matrix(data = rnorm(n*p), nrow = p, ncol = n)

T_alpha <- test_MVSP(gamma=gamma, x=x, w_0=b, beta=0.05)
T_alpha
}
\references{
\insertAllCited{}
}
