% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_summary.R
\name{plot_summary_curves}
\alias{plot_summary_curves}
\title{Plots the mean or median curves in the clusters (functional data)}
\usage{
plot_summary_curves(
  output_clusters,
  data,
  times = NULL,
  type = "mean",
  colors = "red",
  variable_names = NULL
)
}
\arguments{
\item{output_clusters}{list. List of the sites in the clusters: it is the sites_clusters of the output of NPFSS, PFSS, DFFSS, URBFSS, MDFFSS, MRBFSS, MG, MNP, UG or UNP, or the sites_clusters_LH/sites_clusters_W/sites_clusters_P/sites_clusters_R of the MPFSS.}

\item{data}{list of numeric matrices or a matrix. List of nb_sites (or nb_individuals if the observations are by individuals and not by site) matrices of the data, the rows correspond to the variables and each column represents an observation time (multivariate case) ; or Matrix of the data, the rows correspond to the sites (or to the individuals) and each column represents an observation time (univariate case). The times must be the same for each site/individual and they may need to be equally spaced depending on the scan method.}

\item{times}{numeric vector. The times of observations in the data. By default NULL: it supposes equally spaced times of [0;1].}

\item{type}{character. "mean" or "median". If "mean": the mean curves in the clusters are plotted in solid lines, outside the cluster in dots, the global mean curve is in black. If "median": the median curves in the clusters are plotted in solid lines, outside the cluster in dots, the global median curve is in black.}

\item{colors}{character. The colors to plot the clusters' summary curves. If length(colors)==1 then all the clusters will be plotted in this color. Else there must be the same number of elements in colors than the number of clusters}

\item{variable_names}{character vector. The names of the variables if you want the names to appear. By default NULL: the names are var1, var2, etc. Only considered for multivariate functional data.}
}
\value{
No value returned, plots the curves.
}
\description{
This function plots the mean or median curves in the clusters. Only for functional data.
}
\examples{
\donttest{
library(sp)
data("map_sites")
data("funi_data")
coords <- coordinates(map_sites)

res_npfss <- NPFSS(data = funi_data, sites_coord = coords, system = "WGS84",
mini = 1, maxi = nrow(coords)/2)

plot_summary_curves(output_clusters = res_npfss$sites_clusters,
data = funi_data, type = "mean")
plot_summary_curves(output_clusters = res_npfss$sites_clusters,
data = funi_data, type = "median")}
\dontshow{
library(sp)
data("map_sites")
data("funi_data")
indices <- which(map_sites$NAME_3 == "Lille")
coords <- coordinates(map_sites[indices,])
res_npfss <- NPFSS(data = funi_data[indices,], sites_coord = coords,
system = "WGS84", mini = 1, maxi = nrow(coords)/2, MC = 99)
if(length(res_npfss$sites_clusters)>0){
plot_summary_curves(output_clusters = res_npfss$sites_clusters,
data = funi_data[indices,], type = "mean")
}

}

}
