% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htd.dag.R
\name{htd}
\alias{htd}
\title{HTD-DAG}
\usage{
htd(S, g, root = "00")
}
\arguments{
\item{S}{a named flat scores matrix with examples on rows and classes on columns.}

\item{g}{a graph of class \code{graphNEL}. It represents the hierarchy of the classes.}

\item{root}{name of the class that it is the top-level of the hierarchy (\code{def:00}).}
}
\value{
A matrix with the scores of the classes corrected according to the \code{HTD-DAG} algorithm.
}
\description{
Implementation of the top-down procedure to correct the scores of the hierarchy according to the constraints that the score of a
node cannot be greater than a score of its parents.
}
\details{
The \code{HTD-DAG} algorithm modifies the flat scores according to the hierarchy of a DAG \eqn{G} through a unique run across
the nodes of the graph. For a given example \eqn{x}, the flat predictions \eqn{f(x) = \hat{y}} are hierarchically corrected to
\eqn{\bar{y}}, by per-level visiting the nodes of the DAG from top to bottom according to the following simple rule:
\deqn{
\bar{y}_i := \left\{
   \begin{array}{lll}
     \hat{y}_i  & {\rm if} \quad i \in root(G) \\
     \min_{j \in par(i)} \bar{y}_j & {\rm if} \quad \min_{j \in par(i)} \bar{y}_j < \hat{y}_i \\
     \hat{y}_i & {\rm otherwise}
   \end{array}
  \right.
}
The node levels correspond to their maximum path length from the root.
}
\examples{
data(graph);
data(scores);
root <- root.node(g);
S.htd <- htd(S,g,root);
}
