% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCurrentMaps.R
\name{getCurrentMaps}
\alias{getCurrentMaps}
\alias{getCurrentHumanMap}
\alias{getCurrentMouseMap}
\title{Get the current maps for correcting gene symbols}
\usage{
getCurrentHumanMap()
getCurrentMouseMap()
}
\value{
A \code{data.frame} that can be used for \code{map} argument of \code{checkGeneSymbols} function
}
\description{
Valid human and mouse gene symbols can be updated frequently. Use
these functions to get the most current lists of valid symbols, which you can 
then use as an input to the \code{map} argument of \code{checkGeneSymbols}. 
Make sure to change the default \code{species="human"} argument to \code{checkGeneSymbols} 
if you are doing this for mouse. Use \code{getCurrentHumanMap} for HGNC human gene 
symbols from \url{https://www.genenames.org/} and \code{getCurrentMouseMap} for MGI mouse gene 
symbols from \url{https://www.informatics.jax.org/downloads/reports/MGI_EntrezGene.rpt}.
}
\examples{
\dontrun{
## human
new.hgnc.table <- getCurrentHumanMap()
checkGeneSymbols(c("3-Oct", "10-3", "tp53"), map=new.hgnc.table)

## mouse
new.mouse.table <- getCurrentMouseMap()
## Set species to NULL or "mouse" 
checkGeneSymbols(c("Gm46568", "1-Feb"), map=new.mouse.table, species="mouse")
}

}
