% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmstat.getLog.R
\name{mmstat.getLog}
\alias{mmstat.getLog}
\title{mmstat.getLog}
\usage{
mmstat.getLog(session)
}
\arguments{
\item{session}{session object}
}
\value{
HTML code
}
\description{
Returns the internal log message as HTML. In a Shiny app the log message are updated every 100 milliseconds
}
\examples{
# will work only in A Shiny app
if (interactive()) {
  require("shiny")
  ui <- fluidPage(
    titlePanel("getLog example"),
       sidebarLayout(sidebarPanel(
         actionButton("quit", "Quit")),
         mainPanel(textOutput("log"))
   )
 )
#
  server <- function(input, output, session) {
    observeEvent(input$quit, { stopApp() })
    output$log <- renderText({ mmstat.getLog(session) })
  }
#
  shinyApp(ui, server)
}
}
