% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmstat.getVar.R
\name{mmstat.getVar}
\alias{mmstat.getVar}
\title{mmstat.getVar}
\usage{
mmstat.getVar(
  dataname = NULL,
  varname = NULL,
  vartype = NULL,
  na.action = stats::na.omit
)
}
\arguments{
\item{dataname}{integer: number of data set}

\item{varname}{integer: number of variable}

\item{vartype}{character: variable type, one of \code{numeric}, \code{binary}, \code{ordered}, or \code{factor}}

\item{na.action}{function: indicate what should happen when the data contain NAs (default: \link[stats:na.fail]{stats::na.omit})}
}
\value{
a variable of the given type
}
\description{
Returns the from a data set a variable from the given type.
}
\examples{
# make sure that no other data sets are loaded
mmstat.set(datasets=NULL)
mmstat.getDataNames(mmstat.rds("CARS"))
# summary of first numeric variable in first data set in mmstat
str(mmstat.getVar(1, 1, 'numeric'))
# summary of first factor variable in first data set in mmstat
str(mmstat.getVar(1, 1, 'factor'))
}
