% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessoryFunctions.R
\name{typeToSource}
\alias{typeToSource}
\title{Convert AlignType Values to Source Values}
\usage{
typeToSource(alignVector, toSource = TRUE)
}
\arguments{
\item{alignVector}{A vector of character values specifying kinds of four sequence alignment types ("prot","nuc","codon" and "gen"), or three source alignment files ("AA","cDNA", and "gDNA").}

\item{toSource}{A logical. If 'toSource' is true, 'alignType' values are converted to 'source' values. If 'toSource' is false, 'source' values are concerted to 'alignType' values}
}
\value{
A character string of the converted 'align' or 'source' value.
}
\description{
Converts between 'alignType' values, identifying four types of sequence alignments and 'source' values, identifying three kinds of alignment files.
}
\examples{
typeToSource(c("nuc","prot","gen"),TRUE) 

}
