% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LSresids.R
\name{LSresids.default}
\alias{LSresids.default}
\alias{LSresids.mer}
\alias{LSresids}
\alias{LSresids.lmerMod}
\alias{LSresids.lme}
\title{Calculating least squares residuals}
\usage{
\method{LSresids}{default}(object, ...)

\method{LSresids}{mer}(object, level, sim = NULL, standardize = FALSE, ...)

\method{LSresids}{lmerMod}(object, level, standardize = FALSE, ...)

\method{LSresids}{lme}(object, level, standardize = FALSE, ...)
}
\arguments{
\item{object}{an object of class \code{mer} or \code{lmerMod}.}

\item{...}{do not use}

\item{level}{which residuals should be extracted: 1 for case-level
residuals or the name of a grouping factor (as defined in \code{flist} of the 
\code{mer} object) for between-group residuals.}

\item{sim}{optional argument giving the data frame used for LS residuals. This
is used mainly when dealing with simulations. Removed in version 0.3.2.}

\item{standardize}{if \code{TRUE} the standardized level-1
residuals will also be returned (if \code{level = 1}); if \code{"semi"} then
the semi-standardized level-1 residuals will be returned.}
}
\description{
This function calculates least squares (LS) residuals
found by fitting separate LS regression models to each case.
For examples see the documentation for \code{HLMresid}.
}
\references{
Hilden-Minton, J. (1995) Multilevel diagnostics for mixed and hierarchical 
linear models. University of California Los Angeles.
}
\seealso{
\code{\link{HLMresid}}
}
\author{
Adam Loy \email{loyad01@gmail.com}
}
\keyword{models}
\keyword{regression}
