###################################################
### chunk number 1: setup
###################################################
rm(list = ls())
if (!file.exists("tables")) dir.create("tables")
set.seed(290875)
options(prompt = "R> ", width = 63, # digits = 4,
    SweaveHooks = list(leftpar = function()
        par(mai = par("mai") * c(1, 1.05, 1, 1))))
HSAURpkg <- require("HSAUR")
if (!HSAURpkg) stop("cannot load package ", sQuote("HSAUR"))
rm(HSAURpkg)
### </FIXME> hm, R-2.4.0 --vanilla seems to need this
a <- Sys.setlocale("LC_ALL", "C")
### </FIXME>


###################################################
### chunk number 2: ALDII-gee
###################################################
library("gee")


###################################################
### chunk number 3: ALDII-BtheB-data
###################################################
data("BtheB", package = "HSAUR")
BtheB$subject <- factor(rownames(BtheB))
nobs <- nrow(BtheB)
BtheB_long <- reshape(BtheB, idvar = "subject",
                      varying = c("bdi.2m", "bdi.4m", "bdi.6m", "bdi.8m"),
                      direction = "long")
BtheB_long$time <- rep(c(2, 4, 6, 8), rep(nobs, 4))


###################################################
### chunk number 4: ALDII-BtheB-geefit-indep
###################################################
osub <- order(as.integer(BtheB_long$subject))
BtheB_long <- BtheB_long[osub,]
btb_gee <- gee(bdi ~ bdi.pre + treatment + length + drug,
               data = BtheB_long, id = subject, family = gaussian,
               corstr = "independence")


###################################################
### chunk number 5: ALDII-BtheB-geefit-ex
###################################################
btb_gee1 <- gee(bdi ~ bdi.pre + treatment + length + drug,
                data = BtheB_long, id = subject, family = gaussian,
                corstr = "exchangeable")


###################################################
### chunk number 6: ALDII-BtheB-geesummary
###################################################
summary(btb_gee)


###################################################
### chunk number 7: ALDII-BtheB-gee1summary
###################################################
summary(btb_gee1)


###################################################
### chunk number 8: ALDII-respiratory-data
###################################################
data("respiratory", package = "HSAUR")
resp <- subset(respiratory, month > "0")
resp$baseline <- rep(subset(respiratory, month == "0")$status, rep(4, 111))
resp$nstat <- as.numeric(resp$status == "good")


###################################################
### chunk number 9: ALDII-respiratory-fit
###################################################
resp_glm <- glm(status ~ centre + treatment + sex + baseline + age,
                data = resp, family = "binomial")
resp_gee1 <- gee(nstat ~ centre + treatment + sex + baseline + age, data = resp,
                 family = "binomial", id = subject, corstr = "independence",
                 scale.fix = TRUE, scale.value = 1)
resp_gee2 <- gee(nstat ~ centre + treatment + sex + baseline + age, data = resp,
                 family = "binomial", id = subject, corstr = "exchangeable",
                 scale.fix = TRUE, scale.value = 1)


###################################################
### chunk number 10: ALDII-resp-glm-summary
###################################################
summary(resp_glm)


###################################################
### chunk number 11: ALDII-resp-gee1summary
###################################################
summary(resp_gee1)


###################################################
### chunk number 12: ALDII-resp-gee2-summary
###################################################
summary(resp_gee2)


###################################################
### chunk number 13: ALDII-resp-confint
###################################################
se <- summary(resp_gee2)$coefficients["treatmenttreatment","Robust S.E."]
coef(resp_gee2)["treatmenttreatment"] + c(-1, 1) * se * qnorm(0.975)


###################################################
### chunk number 14: ALDII-resp-confint-exp
###################################################
exp(coef(resp_gee2)["treatmenttreatment"] + c(-1, 1) * se * qnorm(0.975))


###################################################
### chunk number 15: ALDII-epilepsy
###################################################
data("epilepsy", package = "HSAUR")
itp <- interaction(epilepsy$treatment, epilepsy$period)
tapply(epilepsy$seizure.rate, itp, mean)
tapply(epilepsy$seizure.rate, itp, var)


###################################################
### chunk number 16: ALDII-plot1
###################################################
layout(matrix(1:2, nrow = 1))
ylim <- range(epilepsy$seizure.rate)
placebo <- subset(epilepsy, treatment == "placebo")
progabide <- subset(epilepsy, treatment == "Progabide")
boxplot(seizure.rate ~ period, data = placebo,
        ylab = "Number of seizures",
        xlab = "Period", ylim = ylim, main = "Placebo")
boxplot(seizure.rate ~ period, data = progabide,
        main = "Progabide", ylab = "Number of seizures",
        xlab = "Period", ylim = ylim)


###################################################
### chunk number 17: ALDII-plot2
###################################################
layout(matrix(1:2, nrow = 1))
ylim <- range(log(epilepsy$seizure.rate + 1))
boxplot(log(seizure.rate + 1) ~ period, data = placebo,
        main = "Placebo", ylab = "Log number of seizures",
        xlab = "Period", ylim = ylim)
boxplot(log(seizure.rate + 1) ~ period, data = progabide,
        main = "Progabide", ylab = "Log number of seizures",
        xlab = "Period", ylim = ylim)


###################################################
### chunk number 18: ALDII-epilepsy-gee
###################################################
per <- rep(log(2),nrow(epilepsy))
epilepsy$period <- as.numeric(epilepsy$period)
epilepsy_glm <- glm(seizure.rate ~ base + age + treatment + offset(per),
                    data = epilepsy, family = "poisson")
epilepsy_gee1 <- gee(seizure.rate ~ base + age + treatment + offset(per),
                     data = epilepsy, family = "poisson", id = subject, corstr = "independence",
                     scale.fix = TRUE, scale.value = 1)
epilepsy_gee2 <- gee(seizure.rate ~ base + age + treatment + offset(per),
                     data = epilepsy, family = "poisson", id = subject, corstr = "exchangeable",
                     scale.fix = TRUE, scale.value = 1)
epilepsy_gee3 <- gee(seizure.rate ~ base + age + treatment + offset(per),
                     data = epilepsy, family = "poisson", id = subject, corstr = "exchangeable",
                     scale.fix = FALSE, scale.value = 1)


###################################################
### chunk number 19: ALDII-espilepsy-glm-summary
###################################################
summary(epilepsy_glm)


###################################################
### chunk number 20: ALDII-espilepsy-gee1-summary
###################################################
summary(epilepsy_gee1)


###################################################
### chunk number 21: ALDII-espilepsy-gee2-summary
###################################################
summary(epilepsy_gee2)


###################################################
### chunk number 22: ALDII-espilepsy-gee3-summary
###################################################
summary(epilepsy_gee3)


