% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.r
\name{htlr_prior}
\alias{htlr_prior}
\title{Generate Prior Configuration}
\usage{
htlr_prior(
  ptype = c("t", "ghs", "neg"),
  df = 1,
  logw = -(1/df) * 10,
  sigmab0 = 2000
)
}
\arguments{
\item{ptype}{The prior to be applied to the model. Either "t" (student-t, default), "ghs" (horseshoe), 
or "neg" (normal-exponential-gamma).}

\item{df}{The degree freedom (aka alpha) of t/ghs/neg prior for coefficients.}

\item{logw}{The log scale of priors for coefficients.
Otherwise, logw is assigned with a normal prior and it will be updated during sampling.}

\item{sigmab0}{The \code{sd} of the normal prior for the intercept.}
}
\value{
A configuration list containing \code{ptype}, \code{alpha}, \code{logw}, \code{eta}, and \code{sigmab0}.
}
\description{
Configure prior hyper-parameters for HTLR model fitting
}
\details{
The output is a configuration list which is to be passed to \code{prior} argument of \code{htlr}.     
For naive users, you only need to specify the prior type and degree freedom, then the other hyper-parameters
will be chosen automatically. For advanced users, you can supply each prior hyper-parameters by yourself.
For suggestion of picking hyper-parameters, see \code{references}.
}
\references{
Longhai Li and Weixin Yao. (2018). Fully Bayesian Logistic Regression 
with Hyper-Lasso Priors for High-dimensional Feature Selection.
\emph{Journal of Statistical Computation and Simulation} 2018, 88:14, 2827-2851.
}
