/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot.plotml;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import ptolemy.gui.ComponentDialog;
import ptolemy.gui.Query;
import ptolemy.plot.EditablePlot;
import ptolemy.plot.plotml.PlotMLApplication;

public class EditablePlotMLApplication
extends PlotMLApplication {
    public EditablePlotMLApplication() throws Exception {
        this((String[])null);
    }

    public EditablePlotMLApplication(String[] stringArray) throws Exception {
        this(new EditablePlot(), stringArray);
    }

    public EditablePlotMLApplication(EditablePlot editablePlot, String[] stringArray) throws Exception {
        super(editablePlot, stringArray);
        editablePlot.setEditable(-1);
        JMenuItem jMenuItem = new JMenuItem("Edit Dataset", 69);
        SelectListener selectListener = new SelectListener();
        jMenuItem.addActionListener(selectListener);
        jMenuItem.setBackground(this._editMenu.getBackground());
        jMenuItem.setFont(this._editMenu.getFont());
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(18, 8, false), "repaint");
        this._editMenu.add(jMenuItem);
    }

    public static void main(String[] stringArray) {
        try {
            EditablePlotMLApplication editablePlotMLApplication = new EditablePlotMLApplication(new EditablePlot(), stringArray);
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            exception.printStackTrace();
        }
        if (_test) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    protected void _about() {
        JOptionPane.showMessageDialog(this, "EditablePlotMLApplication class\nBy: Edward A. Lee, eal@eecs.berkeley.edu and Christopher Hylands, cxh@eecs.berkeley.edu\nVersion 5.3, Build: $Id: EditablePlotMLApplication.java,v 1.25.2.1 2003/05/19 17:26:28 cxh Exp $\n\nFor more information, see\nhttp://ptolemy.eecs.berkeley.edu/java/ptplot\n\nCopyright (c) 1997-2003, The Regents of the University of California.", "About Ptolemy Plot", 1);
    }

    protected void _help() {
        JOptionPane.showMessageDialog(this, "EditablePlotMLApplication is a standalone plot  application.\n  File formats understood: PlotML and Ptplot ASCII.\n  Left mouse button: Zooming.\n  Right mouse button: Editing data (use edit menu to select a dataset).\n\n" + this._usage(), "About Ptolemy Plot", 1);
    }

    protected void _selectDataset() {
        Query query = new Query();
        int n = ((EditablePlot)this.plot).getNumDataSets();
        String[] stringArray = new String[n + 1];
        for (int i = 0; i < n; ++i) {
            stringArray[i + 1] = this.plot.getLegend(i);
            if (stringArray[i + 1] != null) continue;
            stringArray[i + 1] = "" + i;
        }
        stringArray[0] = "none";
        query.setTextWidth(20);
        query.addChoice("choice", "Choose a data set, then drag the right mouse button", stringArray, stringArray[0]);
        ComponentDialog componentDialog = new ComponentDialog((Frame)this, "Select dataset", query);
        String string = componentDialog.buttonPressed();
        if (string.equals("OK")) {
            int n2 = query.getIntValue("choice");
            if (n2 > 0) {
                ((EditablePlot)this.plot).setEditable(n2 - 1);
            } else {
                ((EditablePlot)this.plot).setEditable(-1);
            }
        }
    }

    class SelectListener
    implements ActionListener {
        SelectListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditablePlotMLApplication.this._selectDataset();
        }
    }
}

