% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHVT.R
\name{plotHVT}
\alias{plotHVT}
\title{Plot the hierarchical tessellations.}
\usage{
plotHVT(
  hvt.results,
  line.width = 0.5,
  color.vec = "black",
  pch1 = 21,
  centroid.size = 1.5,
  title = NULL,
  maxDepth = NULL,
  child.level,
  hmap.cols,
  quant.error.hmap = NULL,
  cell_id = FALSE,
  n_cells.hmap = NULL,
  label.size = 0.5,
  sepration_width = 7,
  layer_opacity = c(0.5, 0.75, 0.99),
  dim_size = 1000,
  plot.type = "2Dhvt"
)
}
\arguments{
\item{hvt.results}{(2DProj/2Dhvt/2Dheatmap/surface_plot) List. A list containing the output of \code{trainHVT} function
which has the details of the tessellations to be plotted.}

\item{line.width}{(2Dhvt/2Dheatmap) Numeric Vector. A vector indicating the line widths of the
tessellation boundaries for each level.}

\item{color.vec}{(2Dhvt/2Dheatmap) Vector. A vector indicating the colors of the boundaries of
the tessellations at each level.}

\item{pch1}{(2Dhvt/2Dheatmap) Numeric. Symbol of the centroids of the tessellations
(parent levels). Default value is 21.}

\item{centroid.size}{(2Dhvt/2Dheatmap) Numeric. Size of centroids of first level
tessellations.}

\item{title}{(2Dhvt) Character. Set a title for the plot. (default = NULL)}

\item{maxDepth}{(2Dhvt) Numeric. An integer indicating the number of levels. (default = NULL)}

\item{child.level}{(2Dheatmap/surface_plot) Numeric. Indicating the level for which the heat map is
to be plotted.}

\item{hmap.cols}{(2Dheatmap/surface_plot) Numeric or Character. The column number or column name from
the dataset indicating the variables for which the heat map is to be
plotted.}

\item{quant.error.hmap}{(2Dheatmap) Numeric. A number indicating the quantization error
threshold.}

\item{cell_id}{(2Dhvt) Logical. To indicate whether the plot should have Cell IDs or not for the first layer. 
(default = FALSE)}

\item{n_cells.hmap}{(2Dheatmap/surface_plot) Numeric. An integer indicating the number of
cells/clusters per hierarchy (level)}

\item{label.size}{(2Dheatmap) Numeric. The size by which the tessellation labels should
be scaled. (default = 0.5)}

\item{sepration_width}{(surface_plot) Numeric. An integer indicating the width between two levels}

\item{layer_opacity}{(surface_plot) Numeric. A vector indicating the opacity of each layer/ level}

\item{dim_size}{(surface_plot) Numeric. An integer indicating the dimension size used to create the matrix for the plot}

\item{plot.type}{Character. An option to indicate which type of plot should be generated. Accepted entries are 
'1D','2Dproj','2Dhvt','2Dheatmap'and 'surface_plot'. Default value is '2Dhvt'.}
}
\value{
plot object containing the visualizations of reduced dimension(1D/2D) for the given dataset.
}
\description{
This is the main plotting function to construct hierarchical voronoi tessellations in 1D,2D or
 Interactive surface plot.
}
\examples{
data("EuStockMarkets")
hvt.results <- trainHVT(EuStockMarkets, n_cells = 60, depth = 1, quant.err = 0.1, 
                       distance_metric = "L1_Norm", error_metric = "max",
                       normalize = TRUE,quant_method="kmeans")
                       
#change the 'plot.type' argument to '2Dproj' or '2DHVT' to visualize respective plots.                      
plotHVT(hvt.results, plot.type='1D')

#change the 'plot.type' argument to 'surface_plot' to visualize the Interactive surface plot                   
plotHVT(hvt.results,child.level = 1, 
hmap.cols = "DAX", plot.type = '2Dheatmap')

}
\seealso{
\code{\link{trainHVT}}
}
\author{
Shubhra Prakash <shubhra.prakash@mu-sigma.com>, Sangeet Moy Das <sangeet.das@mu-sigma.com>
}
\keyword{Tessellation_and_Heatmap}
